// Questa funzione prende il contenuto del file numerato e lo stampa nel div "dynamic-content"
let lastSectionId = null; // Questa prende l'ultimo id utilizzato cosìcché non venga ripetuta l'animazione se ricliccato

function writeSection(sectionId) {
    // Se id è uguale allora non fa nulla
    if (sectionId === lastSectionId) {
        return;
    }

    lastSectionId = sectionId;

    // Animazione bellissima
    const dynamicContent = document.getElementById('dynamic-content');
    dynamicContent.style.transition = 'opacity 0.5s'; // Adjust the duration as needed
    dynamicContent.style.opacity = 0;

    // Questo è il fetch per ottenere il contenuto del file numerato e lo stampa nel div "dynamic-content"
    fetch(sectionId)
        .then(response => response.text())
        .then(data => {
            setTimeout(() => {
                dynamicContent.innerHTML = data;
                dynamicContent.style.opacity = 1;
                dynamicContent.scrollIntoView({ behavior: 'smooth', block: 'start' });
            }, 500);
        });
}

// Questa ottiene l'aletezza della navbar dinamicamente
document.addEventListener("DOMContentLoaded", function() {
    function updateMaxHeight() {
        var navbarHeight = document.querySelector('.navbar').offsetHeight;
        document.documentElement.style.setProperty('--navbar-height', navbarHeight + 'px');
    }
    updateMaxHeight();
    window.addEventListener('resize', updateMaxHeight);
});
